<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserPayment extends Eloquent {

	protected $table = 'user_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'payment_type_id', 'payment_id', 'payment_number', 'is_default');
	protected $visible = array('user_id', 'payment_type_id', 'payment_id', 'payment_number', 'is_default');

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function bankAccount()
	{
		return $this->belongsTo('Payment', 'bank_account_id');
	}

	public function accountType()
	{
		return $this->belongsTo('PaymentType', 'account_type_id');
	}

}