<?php

namespace App;

class Orden extends Eloquent {

	protected $table = 'ordenes';
	public $timestamps = true;
	protected $fillable = array('status_id', 'urlComprobantePago', 'urlIdentificacion', 'urlComprobanteDomiciliario', 'urlTarjetaCredito', 'users_id', 'montoFinalTotal', 'montoFinalMensual', 'telefonos_id', 'planes_id');
	protected $visible = array('status_id', 'urlComprobantePago', 'urlIdentificacion', 'urlComprobanteDomiciliario', 'urlTarjetaCredito', 'users_id', 'montoFinalTotal', 'montoFinalMensual', 'telefonos_id', 'planes_id');

	public function status()
	{
		return $this->hasOne('App\Status');
	}

	public function telefono()
	{
		return $this->hasOne('App\Telefono');
	}

	public function planes()
	{
		return $this->hasOne('App\Plan');
	}

	public function user()
	{
		return $this->hasOne('App\User');
	}

}