<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->foreign('certificate_id')->references('id')->on('degrees')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->foreign('chamber_id')->references('id')->on('chambers')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('search', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('physical_conditions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('medical_records', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('medical_records', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('chambers', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->dropForeign('qualifications_doctor_id_foreign');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->dropForeign('qualifications_certificate_id_foreign');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->dropForeign('schedules_chamber_id_foreign');
		});
		Schema::table('search', function(Blueprint $table) {
			$table->dropForeign('search_user_id_foreign');
		});
		Schema::table('physical_conditions', function(Blueprint $table) {
			$table->dropForeign('physical_conditions_patient_id_foreign');
		});
		Schema::table('medical_records', function(Blueprint $table) {
			$table->dropForeign('medical_records_patient_id_foreign');
		});
		Schema::table('medical_records', function(Blueprint $table) {
			$table->dropForeign('medical_records_doctor_id_foreign');
		});
		Schema::table('chambers', function(Blueprint $table) {
			$table->dropForeign('chambers_doctor_id_foreign');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_user_id_foreign');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->dropForeign('patients_user_id_foreign');
		});
	}
}