<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('first_name', 100)->index();
			$table->string('last_name', 100)->index();
			$table->string('father_name', 100);
			$table->string('mother_name', 100);
			$table->date('dob');
			$table->enum('sex', array('MALE', 'FEMALE', 'COMMON'));
			$table->enum('blood_group', array('A+', 'A-', 'B+', 'B-', 'AB+', 'AB-'));
			$table->enum('marital_status', array('Single', 'married', 'Separated', 'Divorced', 'Widowed.'));
			$table->string('mobile', 20)->index();
			$table->string('alternate_mobile', 20);
			$table->string('address');
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}