<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizTable extends Migration {

	public function up()
	{
		Schema::create('quiz', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('course_id')->unsigned();
			$table->string('quiz_name');
			$table->string('quiz_desc')->nullable();
			$table->string('quiz_text');
			$table->integer('quiz_grade');
			$table->time('quiz_start');
			$table->time('quiz_end');
			$table->smallInteger('timelimit')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('quiz');
	}
}