<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 150);
			$table->text('description')->nullable();
			$table->string('icon')->nullable();
			$table->string('image', 100)->nullable();
			$table->enum('status', array('pending', 'available', 'disable'));
			$table->tinyInteger('parent')->default('0');
			$table->enum('type', array('parent', 'subcategory', 'child'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}