<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddsTable extends Migration {

	public function up()
	{
		Schema::create('adds', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image');
			$table->string('link');
			$table->integer('user_id')->unsigned();
			$table->text('description');
			$table->enum('position', array('left', 'top'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('adds');
	}
}