<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('branch_name', 191);
			$table->integer('city_id')->unsigned();
			$table->string('lat', 191);
			$table->string('lang', 191);
			$table->string('address', 191);
			$table->enum('status', array('open', 'close'));
			$table->integer('phone');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}