<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 25);
			$table->string('last_name', 25);
			$table->string('email', 200)->index();
			$table->string('confirmation_token', 200)->nullable();
			$table->string('encrypted_password', 200)->nullable();
			$table->string('reset_password_token', 200)->nullable();
			$table->datetime('reset_password_sent_at')->nullable();
			$table->integer('sign_in_count')->default('0');
			$table->datetime('current_sign_in_at')->nullable();
			$table->datetime('last_sign_in_at')->nullable();
			$table->string('current_sign_in_ip', 200)->nullable();
			$table->string('last_sign_in_ip', 200)->nullable();
			$table->tinyInteger('send_emails')->default('1');
			$table->string('remember_token', 100);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}