<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('company_name', 200);
			$table->string('address', 200);
			$table->string('suite', 200);
			$table->string('zip', 20);
			$table->string('country', 200);
			$table->string('rfp_schoolwatch_email', 200)->nullable();
			$table->string('smart_procure_email', 200)->nullable();
			$table->integer('role_id')->unsigned()->nullable();
			$table->integer('organization_id')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}