<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrganizationsTable extends Migration {

	public function up()
	{
		Schema::create('organizations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->index();
			$table->string('uniq_slug', 100)->index();
			$table->enum('type', array('vendor', 'officer'))->index();
		});
	}

	public function down()
	{
		Schema::drop('organizations');
	}
}