<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('user_type', array('vendor', 'officer'));
			$table->string('name', 50);
			$table->integer('parent_role_id')->nullable();
			$table->tinyInteger('selectable')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}