<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvaluatorsTable extends Migration {

	public function up()
	{
		Schema::create('evaluators', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bid_id')->unsigned()->nullable()->index();
			$table->integer('officer_id')->unsigned()->nullable()->index();
			$table->string('first_name', 500)->nullable();
			$table->string('last_name', 500)->nullable();
			$table->string('email', 500)->nullable();
			$table->string('title', 500)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('evaluators');
	}
}