<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->foreign('risks_and_mitigants_id')->references('id')->on('RiskAndMitigants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->foreign('deal_preference_id')->references('id')->on('DealPreference')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->foreign('sponsorship_id')->references('id')->on('SponsorshipInformation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SponsorshipInformation', function(Blueprint $table) {
			$table->foreign('deal_id')->references('id')->on('DealDescription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('DealDescription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->foreign('asset_valuation_id')->references('id')->on('AssetValuation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->foreign('financing_request')->references('id')->on('FinancingRequest')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('FinancingRequest', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('AssetList')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('FinancingRequest', function(Blueprint $table) {
			$table->foreign('loan_id')->references('id')->on('AssetList')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('RiskAndMitigants', function(Blueprint $table) {
			$table->foreign('deal_id')->references('id')->on('DealDescription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('DealPreference', function(Blueprint $table) {
			$table->foreign('deal_id')->references('id')->on('DealDescription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->foreign('guarantor_id')->references('id')->on('GuarantorInformation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->foreign('borrower_id')->references('id')->on('BorrowerInformation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->foreign('sponsorship_id')->references('id')->on('SponsorshipInformation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->foreign('loan_id')->references('id')->on('BorrowerInformation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->dropForeign('DealDescription_risks_and_mitigants_id_foreign');
		});
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->dropForeign('DealDescription_deal_preference_id_foreign');
		});
		Schema::table('DealDescription', function(Blueprint $table) {
			$table->dropForeign('DealDescription_sponsorship_id_foreign');
		});
		Schema::table('SponsorshipInformation', function(Blueprint $table) {
			$table->dropForeign('SponsorshipInformation_deal_id_foreign');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->dropForeign('AssetList_project_id_foreign');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->dropForeign('AssetList_asset_valuation_id_foreign');
		});
		Schema::table('AssetList', function(Blueprint $table) {
			$table->dropForeign('AssetList_financing_request_foreign');
		});
		Schema::table('FinancingRequest', function(Blueprint $table) {
			$table->dropForeign('FinancingRequest_asset_id_foreign');
		});
		Schema::table('FinancingRequest', function(Blueprint $table) {
			$table->dropForeign('FinancingRequest_loan_id_foreign');
		});
		Schema::table('RiskAndMitigants', function(Blueprint $table) {
			$table->dropForeign('RiskAndMitigants_deal_id_foreign');
		});
		Schema::table('DealPreference', function(Blueprint $table) {
			$table->dropForeign('DealPreference_deal_id_foreign');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->dropForeign('BorrowerAndGuarantorSponsorshipList_guarantor_id_foreign');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->dropForeign('BorrowerAndGuarantorSponsorshipList_borrower_id_foreign');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->dropForeign('BorrowerAndGuarantorSponsorshipList_sponsorship_id_foreign');
		});
		Schema::table('BorrowerAndGuarantorSponsorshipList', function(Blueprint $table) {
			$table->dropForeign('BorrowerAndGuarantorSponsorshipList_loan_id_foreign');
		});
	}
}