<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('nit')->default('0');
			$table->bigInteger('authorization_number')->default('0');
			$table->integer('sfc')->default('1');
			$table->timestamp('emission_date_limit')->nullable();
			$table->string('dosage_key', 255)->nullable();
			$table->text('invoice_law')->nullable();
			$table->integer('periods_nr')->nullable()->default('12');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}