<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'student';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ci', 'first_name', 'last_name_p', 'last_name_m', 'registry_number');

	public function programs()
	{
		return $this->belongsToMany('app\Models\Program', 'program_id');
	}

}