<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->unique();
			$table->string('code', 50)->unique();
			$table->string('group', 50)->index();
			$table->text('address');
			$table->integer('location_id')->unsigned();
			$table->string('location_name', 100)->index();
			$table->string('status', 25)->default('draft');
			$table->text('attributes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}