<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('state_id')->index();
			$table->string('state_type', 25);
			$table->string('state', 50)->index();
			$table->integer('city_id')->index();
			$table->string('city', 50)->index();
			$table->integer('district_id')->unique();
			$table->string('district', 50)->index();
			$table->string('name', 191)->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}