<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_employees', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('user_employees', function(Blueprint $table) {
			$table->dropForeign('user_employees_location_id_foreign');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->dropForeign('user_employees_company_id_foreign');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->dropForeign('user_employees_position_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_location_id_foreign');
		});
	}
}