<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeletherapySessionsTable extends Migration {

	public function up()
	{
		Schema::create('teletherapy_sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('session_date');
			$table->string('session_link');
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->integer('duration');
			$table->enum('status', array(''));
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('teletherapy_sessions');
	}
}