<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamsTable extends Migration {

	public function up()
	{
		Schema::create('exams', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('LECTURE', 'STANDARD', 'COURSE'));
			$table->bigInteger('lecture_id')->unsigned()->nullable();
			$table->bigInteger('standard_id')->unsigned()->nullable();
			$table->bigInteger('course_id')->unsigned()->nullable();
			$table->integer('duration')->unsigned();
			$table->integer('attempts')->unsigned();
			$table->string('solution_video_link');
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('exams');
	}
}