<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrintRequestsTable extends Migration {

	public function up()
	{
		Schema::create('print_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('type', array('BOOK', 'CERTIFICATE'));
			$table->bigInteger('course_id')->unsigned();
			$table->bigInteger('book_id')->unsigned()->nullable();
			$table->enum('status', array('ORDERED', 'APPROVED', 'DELIVERED', 'CANCELED'));
			$table->bigInteger('payment_id')->unsigned()->nullable();
			$table->float('amount');
			$table->bigInteger('coupon_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('print_requests');
	}
}