<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group()
    {
        return $this->hasMany('GroupUser');
    }

    public function group()
    {
        return $this->belongsTo('GroupParent');
    }

    public function groupsie()
    {
        return $this->hasMany('Group');
    }

    public function igroup()
    {
        return $this->hasOne('GroupInfo');
    }

    public function groupt()
    {
        return $this->hasOne('GroupType');
    }

    public function group_items()
    {
        return $this->hasMany('Item');
    }

}