<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->timestamps();
			$table->string('forename', 255);
			$table->string('surname', 255);
			$table->string('position', 255);
			$table->text('bio');
			$table->string('phone');
			$table->text('interest');
			$table->string('attend');
			$table->string('previous_attend');
			$table->integer('user_id')->unsigned();
			$table->string('profile_pic');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}