<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsCommentsTable extends Migration {

	public function up()
	{
		Schema::create('items_comments', function(Blueprint $table) {
			$table->integer('id');
			$table->text('commentcontent');
			$table->integer('item_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('approved_by')->unsigned();
			$table->timestamp('published_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('items_comments');
	}
}