<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTermsTable extends Migration {

	public function up()
	{
		Schema::create('sites_terms', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->integer('site_id')->unsigned();
			$table->string('name');
			$table->date('start_date');
			$table->date('end_date');
			$table->tinyInteger('start_week_number')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites_terms');
	}
}