<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rate extends Model 
{

    protected $table = 'rate';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'question1', 'question2', 'question3', 'question4', 'question5', 'review');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}