<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->index();
			$table->string('slug');
			$table->integer('cpd_hours')->nullable();
			$table->date('start_date');
			$table->date('end_date');
			$table->date('next_date');
			$table->time('start_time');
			$table->time('end_time');
			$table->text('short_description')->nullable();
			$table->text('description')->nullable();
			$table->string('banner')->nullable();
			$table->boolean('is_active');
			$table->text('registration_instructions')->nullable();
			$table->enum('type', array('webinar', 'seminar', 'conference'));
			$table->enum('category', array('accounting_event', 'accounting_tax_event', 'tax_event'));
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}