<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemPriceApisTable extends Migration {

	public function up()
	{
		Schema::create('item_price_apis', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->string('url', 200);
			$table->string('command', 200);
			$table->integer('steam_game_id')->unsigned();
			$table->tinyInteger('abiliity_add_items')->unsigned()->default('0');
			$table->tinyInteger('disable')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_price_apis');
	}
}