<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('game_items', function(Blueprint $table) {
			$table->foreign('steam_game_id')->references('id')->on('steam_games')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_price_apis', function(Blueprint $table) {
			$table->foreign('steam_game_id')->references('id')->on('steam_games')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('game_item_prices', function(Blueprint $table) {
			$table->foreign('game_item_id')->references('id')->on('game_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('game_item_prices', function(Blueprint $table) {
			$table->foreign('item_price_api_id')->references('id')->on('item_price_apis')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('api_txns', function(Blueprint $table) {
			$table->foreign('item_price_api_id')->references('id')->on('item_price_apis')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('game_items', function(Blueprint $table) {
			$table->dropForeign('game_items_steam_game_id_foreign');
		});
		Schema::table('item_price_apis', function(Blueprint $table) {
			$table->dropForeign('item_price_apis_steam_game_id_foreign');
		});
		Schema::table('game_item_prices', function(Blueprint $table) {
			$table->dropForeign('game_item_prices_game_item_id_foreign');
		});
		Schema::table('game_item_prices', function(Blueprint $table) {
			$table->dropForeign('game_item_prices_item_price_api_id_foreign');
		});
		Schema::table('api_txns', function(Blueprint $table) {
			$table->dropForeign('api_txns_item_price_api_id_foreign');
		});
	}
}