<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contact_person_id')->unsigned();
			$table->string('name', 255);
			$table->integer('state_district_local_body_id');
			$table->string('area_name', 255);
			$table->string('landline_number', 15);
			$table->string('landline_number_two');
			$table->string('mobile_one', 20);
			$table->string('mobile_two', 20);
			$table->string('website', 255);
			$table->string('email', 255);
			$table->string('pan_no', 255);
			$table->boolean('active');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}