<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('item_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
			$table->integer('station_id')->unsigned();
			$table->integer('warehouse_id')->unsigned();
			$table->float('quantity');
			$table->date('received_date');
			$table->enum('transaction_type', array('added', 'transfer', 'damaged', 'expired', 'um', 'correction'));
			$table->enum('transfer_type', array('w2s', 's2w', 'w2v', 's2v', 'other'));
			$table->string('remarks', 255);
			$table->enum('status', array('reached', 'notreached', ''));
			$table->integer('decision_by')->unsigned();
			$table->string('serial_number', 255);
			$table->string('p_n', 255);
		});
	}

	public function down()
	{
		Schema::drop('item_transactions');
	}
}