<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('item_name', 255);
			$table->string('item_code', 255)->unique();
			$table->integer('item_unit_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->string('manufacture_id', 255);
			$table->integer('reorder_quantity');
			$table->string('model_no', 255);
			$table->string('image', 255);
			$table->string('remarks', 255);
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}