<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderInfoTable extends Migration {

	public function up()
	{
		Schema::create('order_info', function(Blueprint $table) {
			$table->increments('order_id', true);
			$table->string('type', 50)->nullable();
			$table->string('gender', 10)->nullable();
			$table->integer('Institute')->unsigned();
			$table->integer('quantity')->nullable();
			$table->string('class', 10)->nullable();
			$table->integer('fk_customer_id')->unsigned();
			$table->decimal('order_total', 10,2)->nullable();
			$table->string('division', 20)->nullable();
			$table->string('district', 20)->nullable();
			$table->string('sub_district', 20)->nullable();
			$table->longText('details_address')->nullable();
			$table->string('status', 20)->nullable();
			$table->string('delivery_date', 15)->nullable();
			$table->decimal('delivery_fee')->nullable();
			$table->string('payment_type', 30)->nullable();
			$table->string('payment_status', 10)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_info');
	}
}