<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDressesTable extends Migration {

	public function up()
	{
		Schema::create('dresses', function(Blueprint $table) {
			$table->increments('dresses_id', true);
			$table->integer('fk_class')->unsigned();
			$table->integer('fk_dress_type')->unsigned();
			$table->decimal('price', 10,2)->nullable();
			$table->string('gender', 10)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('dresses');
	}
}