<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderCorporateTable extends Migration {

	public function up()
	{
		Schema::create('order_corporate', function(Blueprint $table) {
			$table->increments('corporate_order_id', true);
			$table->string('type', 20)->nullable();
			$table->string('order_for', 20)->nullable();
			$table->integer('quantity')->nullable();
			$table->string('color', 15)->nullable();
			$table->string('with_embrodary', 15)->nullable();
			$table->string('with_print', 15)->nullable();
			$table->string('customer_name', 25)->nullable();
			$table->string('email', 50);
			$table->string('phone', 20)->nullable();
			$table->text('order_note')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_corporate');
	}
}