<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClassDresses extends Eloquent {

	protected $table = 'dresses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function dressType()
	{
		return $this->hasOne('DressType');
	}

	public function classInfo()
	{
		return $this->hasOne('Classes');
	}

	public function addons()
	{
		return $this->hasMany('Addons');
	}

	public function measurement()
	{
		return $this->hasMany('SchoolClassMeasurement');
	}

}