<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class School extends Eloquent {

	protected $table = 'school';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function classes()
	{
		return $this->hasMany('Classes', 'fk_school');
	}

	public function measurement()
	{
		return $this->hasMany('SchoolClassMeasurement', 'fk_school');
	}

}