<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdmin4CodesTable extends Migration {

	public function up()
	{
		Schema::create('admin4_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('code', 20)->unique();
			$table->string('admin3_code', 20)->index();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin4_codes');
	}
}