<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contact_us', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsells', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsells', function(Blueprint $table) {
			$table->foreign('upsell_type_id')->references('id')->on('upsell_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsell_templates', function(Blueprint $table) {
			$table->foreign('upsell_type_id')->references('id')->on('upsell_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsell_products', function(Blueprint $table) {
			$table->foreign('upsell_id')->references('id')->on('upsells')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsell_collections', function(Blueprint $table) {
			$table->foreign('upsell_id')->references('id')->on('upsells')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsell_tags', function(Blueprint $table) {
			$table->foreign('upsell_id')->references('id')->on('upsells')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('upsell_order_products', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upsell_volume_discounts', function(Blueprint $table) {
			$table->foreign('upsell_id')->references('id')->on('upsells')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('contact_us', function(Blueprint $table) {
			$table->dropForeign('contact_us_user_id_foreign');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_user_id_foreign');
		});
		Schema::table('upsells', function(Blueprint $table) {
			$table->dropForeign('upsells_user_id_foreign');
		});
		Schema::table('upsells', function(Blueprint $table) {
			$table->dropForeign('upsells_upsell_type_id_foreign');
		});
		Schema::table('upsell_templates', function(Blueprint $table) {
			$table->dropForeign('upsell_templates_upsell_type_id_foreign');
		});
		Schema::table('upsell_products', function(Blueprint $table) {
			$table->dropForeign('upsell_products_upsell_id_foreign');
		});
		Schema::table('upsell_collections', function(Blueprint $table) {
			$table->dropForeign('upsell_collections_upsell_id_foreign');
		});
		Schema::table('upsell_tags', function(Blueprint $table) {
			$table->dropForeign('upsell_tags_upsell_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('upsell_order_products', function(Blueprint $table) {
			$table->dropForeign('upsell_order_products_order_id_foreign');
		});
		Schema::table('upsell_volume_discounts', function(Blueprint $table) {
			$table->dropForeign('upsell_volume_discounts_upsell_id_foreign');
		});
	}
}