<?php

namespace App\Models;

class Artist extends Eloquent {

	protected $table = 'artists';
	public $timestamps = true;
	protected $fillable = array('name', 'artist_url');

	public function episodes()
	{
		return $this->morphedByMany('App\Models\Episode', 'artistable');
	}

	public function shows()
	{
		return $this->morphedByMany('App\Models\Show', 'artistable');
	}

	public function articles()
	{
		return $this->morphToMany('App\Models\Article', 'articlable');
	}

}