<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('title_ar');
			$table->text('title_en');
			$table->text('short_desc_ar');
			$table->text('short_desc_en');
			$table->longText('desc_ar');
			$table->longText('desc_en');
			$table->string('image', 191);
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}