<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 150);
			$table->string('country', 150);
			$table->string('city', 150);
			$table->string('street', 150);
			$table->integer('user_id')->unique()->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}