<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function address()
	{
		return $this->hasOne('App\Address');
	}

	public function groups()
	{
		return $this->belongsToMany('App\Group');
	}

	public function country()
	{
		return $this->belongsTo('App\Country');
	}

	public function post()
	{
		return $this->hasMany('App\Post');
	}

}