<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Doctor extends Eloquent {

	protected $table = 'doctors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'tel_no');

	public function user()
	{
		return $this->belongsTo('\User');
	}

}