<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Guardian extends Eloquent {

	protected $table = 'guardians';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'relationship', 'address', 'tel_no');

	public function user()
	{
		return $this->belongsTo('\User');
	}

}