<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Skill extends Eloquent {

	protected $table = 'skills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('standard', 'spin', 'pop', 'front', 'rear', 'side', 'scrabble', 'drop', 'punt', 'grubber', 'goal');

	public function user()
	{
		return $this->belongsTo('\User');
	}

}