<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('email', 100);
			$table->string('password', 100);
			$table->boolean('active')->default(1);
			$table->bigInteger('profile_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}