<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('Vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('Vid')->index();
			$table->string('Vin', 150);
			$table->integer('CommissionNumber');
			$table->string('ColourGroup', 150);
			$table->string('Colour', 150);
			$table->string('Model', 150);
			$table->integer('ModelId');
			$table->string('BodyStyle', 150);
			$table->string('VehicleClass', 150);
			$table->string('Description', 150);
			$table->string('ShortDescription', 150);
			$table->string('FuelType', 150);
			$table->string('Transmission', 150);
			$table->string('TransmissionType', 150);
			$table->integer('EngineId')->unsigned();
			$table->string('MonthlyPrice', 150);
			$table->integer('UpholsteryId')->unsigned();
			$table->mediumText('EquipmentAdditional');
			$table->integer('RetailerId')->unsigned();
			$table->integer('MediaId')->unsigned();
			$table->integer('ConsumptionUrbanId')->unsigned();
			$table->integer('ConsumptionExtraUrbanId')->unsigned();
			$table->integer('ConsumptionCombinedId')->unsigned();
			$table->integer('EmissionUrban');
			$table->integer('EmissionExtraUrban');
			$table->integer('EmissionCombined');
			$table->integer('EnergyEfficiencyClassId')->unsigned();
			$table->string('EmissionDirective', 150);
			$table->string('ProductRange', 150);
			$table->string('VehicleType', 150);
			$table->string('ChassisNumber', 150);
			$table->string('Line', 150);
			$table->string('ModelYear', 150);
			$table->string('SalesDescription', 150);
			$table->boolean('HasError');
			$table->boolean('IsAvailableOnline');
			$table->boolean('IsAvailableForReservationAtRetailer');
			$table->boolean('IsVehicleReserved');
			$table->boolean('IsAvailableForReservation');
			$table->boolean('IsOfferAvailable');
			$table->string('RetailPriceExVAT', 150);
			$table->string('ModelYearCode', 150);
			$table->integer('OTR');
			$table->integer('Mileage');
			$table->string('RetailPrice_IncVAT', 150);
			$table->boolean('IsVehicleReservationPending');
		});
	}

	public function down()
	{
		Schema::drop('Vehicles');
	}
}