<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerRequestsTable extends Migration {

	public function up()
	{
		Schema::create('CustomerRequests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('VehicleId')->unsigned();
			$table->integer('RetailerId')->unsigned();
			$table->string('email', 150);
			$table->string('phone', 150);
			$table->string('FirstName', 150);
			$table->string('LastName', 150);
			$table->string('Title', 150);
			$table->text('Description');
			$table->string('ContactPreference', 150);
			$table->text('Address');
			$table->string('RequestType', 150);
		});
	}

	public function down()
	{
		Schema::drop('CustomerRequests');
	}
}